--require( "quest/activity_mode/activity_complete_dialog.lua" );
require( "quest/activity_mode/activity_timer.lua" );

ACTIVITY_BONUS_SCORE_MAX = 1500; -- max score that no-one could possibly attain
ACTIVITY_BASE_SCORE = 100; -- base score that everyone gets regardless
ACTIVITY_LEVEL_MAX = 16; -- the maximum number of levels per activity
ACTIVITY_EXPERT_THRESHOLD = 1100; -- scores over this are 'expert'
ACTIVITY_MODERATE_THRESHOLD = 600; -- scores over this are good

function show_activity_results()
	local activity_name = game:GetString("activity_mode_name");
	local activity_level = game:Get("activity_mode_level");
	local best_activity_score = game:Get(activity_name .. "_level_" .. activity_level .. "_score");
	local best_unlocked_level = game:Get(activity_name .. "_unlocked");
	local activity_score = get_activity_score(activity_level);
	local activity_total_score = get_activity_total_score();
	local activity_time = get_activity_time();
	local activity_expert = 0;
	
	if activity_score >= ACTIVITY_EXPERT_THRESHOLD then
		activity_expert = 1;
	elseif activity_score >= ACTIVITY_MODERATE_THRESHOLD then
		activity_expert = 0; --not expert but okay
	else
		activity_expert = -1;
	end
	
	if activity_score > best_activity_score then
		game:Set(activity_name .. "_level_" .. activity_level .. "_score", activity_score);
		activity_total_score = get_activity_total_score();
		-- we have a new best score for this level, our total score must have increased
		game:SetScore(activity_total_score);
	end

	if activity_expert == 1 then
		game:Set(activity_name .. "_level_" .. activity_level .. "_expert", activity_expert);
	end

	if best_unlocked_level < (activity_level+1) and activity_level < ACTIVITY_LEVEL_MAX then
		game:Set(activity_name .. "_unlocked", best_unlocked_level + 1);
	end

	-- set data for the activity dialog to read from
	game:Set("activity_dialog_level", activity_level);
	game:Set("activity_dialog_score", activity_score);
	game:Set("activity_dialog_total_score", activity_total_score);
	game:Set("activity_dialog_time", activity_time);
	game:Set("activity_dialog_expert", activity_expert);
	
	-- save now to be on the safe side
	game:SaveGame();

	scene:ChainToSubScene("activity_complete_dialog");
	wait_subscene();
	
	local activity_mode_next_level = game:Get("activity_mode_next_level");
	
	if activity_mode_next_level == 1 then
		if activity_level < ACTIVITY_LEVEL_MAX then
			game:Set("activity_mode_level", activity_level + 1);
		else
			game:Set("activity_mode_level", 1);
		end
	end
	
	next_activity(scene.FLO);
	help_panel_activity_mode_intro();
end

function start_activity(flo)
	setup_activity();
	spawn_activity_timer();
	
	if IsCheatMode() then
		spawn_button(pass_activity_button_spec);
	end
end

start_button_spec = 
{
	name = "START_BUTTON";
	text = "start";
	halo = "quest/objects/button_thin";
	position = { x = 588, y = 530+hud_lower_offset };
	image = "buttons/button_thin";
	rolloversound = "audio/sfx/button_rollover";
	clicksound = "audio/sfx/buttonclick";
	depth = 50;
	say_spec =
		{
			color = { a = 1, r = 0, g = 0, b = 0 },
			color_over = { a = 1, r = 0, g = 0, b = 0 },
			y = 11,
			x = 0,
			w = 110,
			h = 20,
			bubble = false,
			lineheight = 14,
			outline_size = 0,
			font = "fonts/franklingothic_demicond.mvec"; 
			anchor = ANCHOR.CENTER
		};
	
	on_click = function(flo, actor)
		help_panel_say_raw("");
		flo:StartProc(start_activity);
		actor:Expire();
	end;
}

function help_panel_activity_mode_intro()
	local activity_mode_level = game:Get("activity_mode_level");
	if activity_mode_level == 1 then
		help_panel_say_raw(scene:grabstring("activity_mode_intro_1"));
	elseif activity_mode_level == ACTIVITY_LEVEL_MAX then
		help_panel_say_raw(scene:grabstring("activity_mode_intro_16"));
	else
		help_panel_say_raw(scene:grabstring("activity_mode_intro_2_15"));
	end
end